function out=pcsubmatrix(x,c1,c2)
% from an initial matrix x, the function excludes the columns c1 and c2
if size(x,2)==1
    error('x is a matrix or a row vector')
end
[R,C]=size(x);
if c1>C || c2>C
    error('c1 and c2 should be less that the column size of x')
end
if c1==c2
    display('only on column will be excluded')
end
C1=x(:,1:c1-1);
C2=x(:,c1+1:c2-1);
C3=x(:,c2+1:C);
out=[C1 C2 C3];